﻿var taskSchedules = {
    context: $(".v-taskSchedules"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-taskSchedulesTable", this.context).a4datatable({
            advancedFilter: true,
            ajaxAction: a4.getAction("GetTaskSchedules", "TaskSchedules", "Project"),
            columns: [
                { "Name": "SyncTooltip", "Tooltip": true, "DisplayCondition": function (data) { return data.Synchronizable || !data.Editable; }, "AdvancedFilter": false },
                { "Name": "ProjectName", "Title": resources.Project },
                { "Name": "TaskName", "Title": resources.Task, "Data": "TaskName" },
                { "Name": "ScheduleName", "Title": resources.ScheduleName },
                { "Name": "TaskType", "Title": resources.TaskClassName, "Data": "TaskType", "Type": "enum", "EnumType": "TaskTypeEnum" },
                { "Name": "Enabled", "Title": resources.IsEnabled, "Data": "EnabledLabel", "Type": "boolean" },
                { "Name": "RunType", "Title": resources.RunType, "Data": "RunType", "Type": "enum", "EnumType": "RunTypeEnum" },
                { "Name": "Recurrence", "Title": resources.Recurrence, "Data": "RecurrenceLabel", "Tooltip": "RecurrenceTooltip", "Sortable": false, "AdvancedFilter": false },
                { "Name": "RecurrenceType", "Title": resources.RecurrenceType, "Type": "enum", "EnumType": "RecurrenceTypeEnum"},
                { "Name": "LastRunDateTime", "Title": resources.LastRunDateTime, "Type": "datetime", "DefaultValue": resources.Never },
                { "Name": "NextRunDateTime", "Title": resources.NextRunDate, "Data": "NextRun", "Type": "datetime", "DefaultValue": resources.Never },
                { "Name": "StartDateTime", "Title": resources.StartDateTime, "Type": "datetime" },
                { "Name": "EndDateTime", "Title": resources.EndDateTime, "Type": "datetime", "DefaultValue": resources.Never },
                { "Name": "Description", "Title": resources.Description },
                { "Name": "ModifiedBy", "Title": resources.LastEditBy },
                { "Name": "Modified", "Title": resources.LastEditOn, "Type": "datetime" },
                { "Name": "ScheduleTimeZone", "Title": resources.scheduleTimeZoneId },
                { "Name": "ScheduleId", "Title": "", "Visible": false, "HideInSelector": true }
            ],
            stateKey: "TaskSchedules",
            allowRowSelection: true,
            contextMenuItems: taskSchedules.getContextMenuItems(),
            toolBarItems: taskSchedules.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].ScheduleId);
                }

                switch (action) {
                    case "delete":
                        taskSchedules.deleteTaskSchedules(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var taskId = row["TaskId"];
                var scheduleId = row["ScheduleId"];
                var scheduleName = row["ScheduleName"];
                var options = { focusFirstField: false, afterClose: function () { taskSchedules.refreshContent(); } };

                switch (action) {
                    case "runNow":
                        modalDialog.showConfirmDialog(confirmExecuteTaskScheduleResources, function () {
                            a4.callServerMethod(a4.getAction("RunTaskSchedule", "TaskSchedules", "Project"), { scheduleId: scheduleId }, function () { taskSchedules.refreshContent(); });
                        }, 200, 420, false, { "schedule": scheduleName });
                        break;

                    case "viewHistory":
                        modalDialog.showWindow(a4.getAction("TaskScheduleLogs", "TaskSchedules", "Project", { scheduleId: scheduleId }), 650, 950, null);
                        break;

                    case "edit":
                        modalDialog.showWindow(a4.getAction("EditTaskSchedule", "TaskSchedules", "Project", { taskScheduleId: scheduleId }), 650, 700, options);
                        break;

                    case "copy":
                        modalDialog.showWindow(a4.getAction("EditTaskSchedule", "TaskSchedules", "Project", { taskScheduleId: scheduleId, isCopy: true }), 650, 700, options);
                        break;

                    case "sync":
                        modalDialog.showConfirmDialog(confirmSyncTaskScheduleResources, function () {
                            a4.callServerMethod(a4.getAction("SyncTaskSchedule", "TaskSchedules", "Project"), { scheduleId: scheduleId }, function () { taskSchedules.refreshContent(); });
                        }, 250, 450, false, { "schedule": scheduleName });
                        break;

                    case "override":
                        modalDialog.showConfirmDialog(confirmOverrideTaskScheduleResources, function () {
                            a4.callServerMethod(a4.getAction("OverrideTaskSchedule", "TaskSchedules", "Project"), { scheduleId: scheduleId }, function () { taskSchedules.refreshContent(); });
                        }, 250, 400, false, { "schedule": scheduleName });
                        break;

                    case "delete":
                        taskSchedules.deleteTaskSchedules([scheduleId]);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchTaskSchedules }
        });
    },
    bindEvents: function () {
        var options = { afterClose: function () { taskSchedules.refreshContent(); } };

        taskSchedules.context.on("click", ".h-newTaskchedule", function () {
            modalDialog.showWindow(a4.getAction("EditTaskSchedule", "TaskSchedules", "Project"), 650, 700, options);
        });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    getContextMenuItems: function () {
        return [
            { "Action": "copy", "Label": resources.Copy, "DisplayCondition": function (data) { return !data.Synchronizable && data.Editable; } },
            { "Action": "delete", "Label": resources.Delete },
            { "Action": "edit", "Label": resources.Properties, "DisplayCondition": function (data) { return !data.Synchronizable && data.Editable; } },
            { "Action": "sync", "Label": resources.Synchronize, "DisplayCondition": function (data) { return data.Synchronizable; }},
            { "Action": "override", "Label": resources.Override, "DisplayCondition": function (data) { return data.Synchronizable || !data.Editable; }},
            { "Divider": true },
            { "Action": "runNow", "Label": resources.ExecuteNow, "DisplayCondition": function (data) { return data.Enabled && !data.Synchronizable; }},
            { "Action": "viewHistory", "Label": resources.ViewHistory }
        ]
    },
    getToolBarItems: function () {
        return [{ "Action": "delete", "Label": resources.Delete }];
    },
    deleteTaskSchedules: function (scheduleIds) {
        var itemsCount = scheduleIds.length;

        if (typeof itemsCount === "undefined")
            itemsCount = 1;

        modalDialog.showConfirmDelete(confirmDeleteTaskScheduleResources, function () {
            a4.callServerMethod(a4.getAction("DeleteTaskSchedule", "TaskSchedules", "Project"), { schedules: scheduleIds },
            function (result) {
                taskSchedules.refreshContent();
            });
        }, itemsCount);
    }
};

$(document).ready(function () {
    if (taskSchedules.context.length > 0) {
        taskSchedules.initializeDataTable();
        taskSchedules.bindEvents();
    }
});